IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_CLI_PDV_CD_COND_PGTO')
BEGIN
	DROP TRIGGER TRG_RC_CLI_PDV_CD_COND_PGTO
END
GO
CREATE TRIGGER [dbo].[TRG_RC_CLI_PDV_CD_COND_PGTO] ON [dbo].[RC_CLI] FOR 
	INSERT
AS
	DECLARE @CD_COND_PGTO INT
	SET @CD_COND_PGTO=ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE = 'CD_COND_PGTO_PADRAO'),2);

	UPDATE
		r
	SET
		r.CD_COND_PGTO = @CD_COND_PGTO
	FROM 
		RC_CLI r INNER JOIN INSERTED i ON
		r.CD_EMP = i.CD_EMP AND
		r.CD_CLI = i.CD_CLI
	WHERE 
		i.CD_COND_PGTO <> @CD_COND_PGTO 
		OR i.CD_COND_PGTO IS NULL;

	UPDATE
		R
	SET
		R.CONTRIBUINTE = 9
	FROM 
		RC_CLI R INNER JOIN INSERTED I ON
		R.CD_EMP = I.CD_EMP AND
		R.CD_CLI = I.CD_CLI
	WHERE
		I.CONTRIBUINTE=0
		AND (I.INSC_MUNI='ISENTO'
		AND I.INSC_EST='ISENTO')
GO

ALTER TABLE [dbo].[RC_CLI] ENABLE TRIGGER [TRG_RC_CLI_PDV_CD_COND_PGTO]
GO


